local car = ac.getCar()
local valveModeEnabled = false
local lastExtraE = false

-- Sound players
local valveSound = ui.MediaPlayer()
valveSoundsetSource('.soundvalve_open.wav')
valveSoundsetVolume(ac.getAudioVolume('main')  1.5)
valveSoundsetLooping(false)

local burbleSound = ui.MediaPlayer()
burbleSoundsetSource('.soundburble.wav')
burbleSoundsetVolume(ac.getAudioVolume('main')  1.2)
burbleSoundsetLooping(false)

function script.update(dt)
    -- Toggle logic on key press (not hold)
    if car.extraE and not lastExtraE then
        valveModeEnabled = not valveModeEnabled

        if valveModeEnabled then
            -- Turn ON valve mode
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineExt, 'valved', 1.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.Turbo, 'valved', 1.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineInt, 'valved', 1.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineExt, 'burbles', 1.0)

            carsetEnginePowerMultiplier(1.02)

            valveSoundplay()
            burbleSoundplay()
        else
            -- Turn OFF valve mode
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineExt, 'valved', 0.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.Turbo, 'valved', 0.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineInt, 'valved', 0.0)
            ac.CarAudioTweak.setParameter(ac.CarAudioEventID.EngineExt, 'burbles', 0.0)

            carsetEnginePowerMultiplier(1.00)
        end
    end

    -- Update last input state
    lastExtraE = car.extraE
end
