--#region
-- ####################################################################################
-- #                                                                                  #
-- #  ██╗███╗   ██╗████████╗███████╗██████╗ ██╗ ██████╗ ██████╗                       #
-- #  ██║████╗  ██║╚══██╔══╝██╔════╝██╔══██╗██║██╔═══██╗██╔══██╗                      #
-- #  ██║██╔██╗ ██║   ██║   █████╗  ██████╔╝██║██║   ██║██████╔╝                      #
-- #  ██║██║╚██╗██║   ██║   ██╔══╝  ██╔══██╗██║██║   ██║██╔══██╗                      #
-- #  ██║██║ ╚████║   ██║   ███████╗██║  ██║██║╚██████╔╝██║  ██║                      #
-- #  ╚═╝╚═╝  ╚═══╝   ╚═╝   ╚══════╝╚═╝  ╚═╝╚═╝ ╚═════╝ ╚═╝  ╚═╝                      #
-- #                                                                                  #
-- #  ███╗   ███╗ ██████╗  ██████╗ ██████╗     ██╗     ██╗ ██████╗ ██╗  ██╗████████╗  #
-- #  ████╗ ████║██╔═══██╗██╔═══██╗██╔══██╗    ██║     ██║██╔════╝ ██║  ██║╚══██╔══╝  #
-- #  ██╔████╔██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║  ███╗███████║   ██║     #
-- #  ██║╚██╔╝██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║   ██║██╔══██║   ██║     #
-- #  ██║ ╚═╝ ██║╚██████╔╝╚██████╔╝██████╔╝    ███████╗██║╚██████╔╝██║  ██║   ██║     #
-- #  ╚═╝     ╚═╝ ╚═════╝  ╚═════╝ ╚═════╝     ╚══════╝╚═╝ ╚═════╝ ╚═╝  ╚═╝   ╚═╝     #
-- #                                                                                  #
-- #  ██████╗ ██╗   ██╗    ██╗   ██╗███████╗████████╗ █████╗ ██╗  ██╗██╗              #
-- #  ██╔══██╗╚██╗ ██╔╝    ██║   ██║██╔════╝╚══██╔══╝██╔══██╗██║  ██║██║              #
-- #  ██████╔╝ ╚████╔╝     ██║   ██║███████╗   ██║   ███████║███████║██║              #
-- #  ██╔══██╗  ╚██╔╝      ██║   ██║╚════██║   ██║   ██╔══██║██╔══██║██║              #
-- #  ██████╔╝   ██║       ╚██████╔╝███████║   ██║   ██║  ██║██║  ██║███████╗         #
-- #  ╚═════╝    ╚═╝        ╚═════╝ ╚══════╝   ╚═╝   ╚═╝  ╚═╝╚═╝  ╚═╝╚══════╝         #
-- #                                                                                  #
-- ####################################################################################
--#endregion

--- Version 1.0, 19/12/2024
--- Seems to be stable, but I didn't test it much
--- For my other AC stuff and help: https://t.me/ashadyalleyinchibacity 
--- 
--- This work © 2024 by Ustahl is licensed under CC BY-SA 4.0 
--- To view a copy of this license, visit
--- https://creativecommons.org/licenses/by-sa/4.0/

--- Install instructions:
--- Put the script into the extension folder, then put the section below
--- in your ext_config.ini.
--- 
--- [SCRIPT...]
--- SCRIPT='interior_mood_lightning.lua'

--- Available colors. 
--- 
--- Use default SDK ones (rgb.color.xxx)
--- or rgb(R, G, B) where R, G and B are numbers in 0 - 1 range.
--- 
--- If you found a color code that has R, G or B in 0 - 255 range
--- just do rgb(R / 255, G / 255, B / 255)
--- 
--- You can change the brightness/multiplier lower in emissiveMult
local COLORS = {
    rgb(2,2, 9),
    rgb(9, 1, 1),
    rgb(2, 9, 2),
    rgb(9, 9, 9),
    rgb(3, 5, 5),
    rgb(200 / 255, 64 / 255, 1)
}

--- To add more than 1 mesh or extra light to lists add a comma
--- and press Enter after each one (that's just for organization).
--- If you don't need left/right door emissives or extra lights
--- just leave the list empty by removing the placeholder.
---
--- Example:
--- local EMISSIVE_MAIN = {
---     "int_ambient",
--- 	"int_ambient_vents",
--- 	"int_ambient_door_left"
--- }


--- Main emissives that will always change colors
---
--- Mesh names, same as defining emissives in ext_config
local EMISSIVE_MAIN = {
    "m235_317.008"
}

-- Emissives on the left door (won't change when it's opened)
local EMISSIVE_LEFT_DOOR = {
    "m235_242"
}

-- Emissives on the right door (won't change when it's opened)
local EMISSIVE_RIGHT_DOOR = {
    "LeatherSecondaryPassDoor.002"
}

--- Extra lights (in the footwell, etc.)
--- 
--- If defined with "[LIGHT_EXTRA_...]" use CSP Debug -> Lights -> Debug lights
--- to see the indexes they get assigned
local LIGHTS = {
    "light_extra_name_here"
}

-- Change this to change the default color (this is the index in the table)
local currentColor = 1

-- Change emissiveMult to make the emissives brighter if needed
-- (same as 4th value in ext_config emissives)
local emissiveMult = 5

--#region You probably don't need to touch this
local TOTAL_COLORS = #COLORS
local emissiveColor = rgb(0, 0, 0)
local isLeftDoorOpen = false
local isRightDoorOpen = false
local _interval
local storage = ac.storage({
    savedColor = currentColor
})

local _initialized = false
--#endregion

local function applyColor()
    emissiveColor = emissiveColor:set(COLORS[currentColor]):scale(emissiveMult)

    -- Set main emissive color (everything except doors)
    for _, mesh in pairs(EMISSIVE_MAIN) do
        ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
    end

    -- Set left door emissive color if it's closed
    if not isLeftDoorOpen and #EMISSIVE_LEFT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_LEFT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    -- Set right door emissive color if it's closed
    if not isRightDoorOpen and #EMISSIVE_RIGHT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_RIGHT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    if #LIGHTS > 0 then
        for _, light in pairs(LIGHTS) do
            ac.accessCarLight(light).color = COLORS[currentColor]
        end
    end
end

local function nextColor()
    if currentColor == TOTAL_COLORS then
        currentColor = 1
    else
        currentColor = currentColor + 1
    end
    storage.savedColor = currentColor
    applyColor()
end

local function updateDoors()
    -- Left door, replace extraC with appropriate extra switch
    if car.extraH then
        isLeftDoorOpen = true
    elseif isLeftDoorOpen then
        isLeftDoorOpen = false
        applyColor()
    end
    -- Right door, replace extraD with appropriate extra switch
    if car.extraI then
        isRightDoorOpen = true
    elseif isRightDoorOpen then
        isRightDoorOpen = false
        applyColor()
    end
end

-- This was kind of a hacky attempt to fix saved color not applying at startup
-- before I discovered you just gotta remove ext_config emissives, will rewrite
-- later if I decide to improve on this because it only runs once anyway
local function initialize()
    currentColor = storage.savedColor
    local defColor = emissiveColor:set(COLORS[currentColor]):scale(emissiveMult):vec3()
    local testMesh = ac.findNodes(EMISSIVE_MAIN[1]):findMeshes(EMISSIVE_MAIN[1])

    _interval = setInterval(function ()
        if testMesh:getMaterialPropertyValue(1, "ksEmissive") ~= defColor then
            applyColor()
        else
            _initialized = true
            clearInterval(_interval)
			_interval = nil
        end
    end, 0.05, "Initialize loop")
end

function script.update(dt)
    -- To change what Extra scrolls through colors:
    -- extraA = ac.setExtraSwitch(0, false)
    -- extraB = ac.setExtraSwitch(1, false)
    -- extraC = ac.setExtraSwitch(2, false)
    -- and so on

    if not _initialized then
        initialize()
    else
        if car.extraA then                  -- replace with extraB, extraC...
            ac.setExtraSwitch(0, false)     -- replace the number with 1, 2...
            if car.extraA then              -- replace with extraB, extraC...
                nextColor()
            end
        end
        updateDoors()
    end
end