--[[
    Yokai 12-23-2022
	Dareks 29-05-2023 - hybrid prototype with parts from Yokai 29-12-2022
	
	-- TODO: 
		--  fix throttle cut on upshift to stop it from colliding with downshift cut - propably impossible - kunos cut is better
		--	driving modes - use shifter to select/ press a button - same with reverse/ parking gear
		--	other forgotten stuff :) - yes
	--]]

------------------------------------------------------------------------------------------------------------------

-- yokai utilities
    -- (aka range) converts an input between x1 and x2, to an output between y1 and y2
    local function interpolate(x1, x2,  input,  y1, y2)
        input = math.clamp(input, x1, x2)
        return y1 + ((input - x1) / (x2 - x1)) * (y2 - y1)
    end

    local function safe(input) -- help prevent stupid issues when logging
        if (type(input) == "table") then
            return "table"
        end
        return input
    end
    local function log(input)
        if(true) then ac.log("![auto] " .. safe(input)) end end
    local function bug(name, value)
        if(true) then ac.debug("![auto] "..name, value) end end
		
------------------------------------------------------------------------------------------------------------------

-- Criticals

    local is_car_script = (ac.accessCarPhysics ~= nil)
    ac.log("is_car_script: " .. (is_car_script and "true" or "false"))

    local data = (is_car_script) 
	local data = ac.accessCarPhysics() 
	--local data = ac.getJoypadState()
    local car  = ac.getCar(0)
    local phy  = ac.getCarPhysics(0)
    local gear, speed, rpm, throttle, braking = 0,0,0,0,0
	local auto = { }
	local target = 0
	local ready = false


------------------------------------------------------------------------------------------------------------------

-- Gearing
    -- gears table data is automated
    local gears = { } -- max speed for each gear (ie; [1]=40, [2]=80 etc)
    local calc = {
        speed = 0,
        gear  = 0,
        final = phy.finalRatio,
        tire  = (car.wheels[1].tyreRadius * 2),
        rpm   = car.rpmLimiter,
    }
    for x=2, #phy.gearRatios-1, 1 do
        -- this goes 1=nil, 2-3-4..., nil again ??
        -- Skipping the first and last, the middle should be gears
        -- 2,3,4 = 1,2,3
        calc.gear = (phy.gearRatios[x] or 0)

        -- MPH using tire inches: gear speed = (rpm * diameter * pi) / (final * gear * 1056)
        calc.speed = (calc.rpm * calc.tire * math.pi) / (calc.final * calc.gear * 1056)
                    * 39 -- convert tire to meters
                    * 1.60934 -- convert from mph to kmh
                    
        gears[x-1] = calc.speed
    end

    --for x=1, #gears, 1 do log("Gear "..x..": " .. gears[x] / 1.609) end

    -- Helper function: returns a gear's top speed.
    -- n = gear number, none or 0 for current
    --      Positive returns that gear (5 = gear 5)
    --      Negative returns minus current (-2 = current gear -2)
    -- t = optional return multiplier
    local function _gear(n, t)
        n = n or gear 
            if (n <= 0) then 
				n = gear + n
				end
            if (n <  1) then 
				n = 1
				end
        t = t or 1
        return gears[n] * t
    end

------------------------------------------------------------------------------------------------------------------

function script.update(dt)

    -- Debugging
        bug("! Running", " ")

        gear     = data.gear     or 0
        speed    = data.speedKmh or 0
        rpm      = data.rpm      or 0
        throttle = data.gas      or 0
        braking  = data.brake    or 0
		
        -- Remove reverse from gear index (neutral=0, first=1, ...)
        if (gear >= 0)  then gear = gear-1 end

         --Debug
		local car = ac.getCar(0)
		local ptratio = (car.drivetrainPower * throttle)
		local ttratio = (car.drivetrainTorque * throttle)
		local speed_mph = speed / 1.60934
		--local shift_rpm = (car.rpmLimiter - car.engineIdle) * (target / 100)
		ac.debug("Current Wheel Power", ptratio)
		ac.debug("Current Wheel Torque", ttratio)
        ac.debug("Gear", gear)
        --ac.debug("Shift RPM", shift_rpm)
        ac.debug("Speed KMH", speed)
        ac.debug("Speed MPH", speed_mph)
        ac.debug("Engine RPM", rpm)
        ac.debug("Throttle", throttle)
        ac.debug("Brake",  braking)
		ac.debug("Target", target)

         --Disable (diagnostic)
         --if (true) then return end



    -- Offset stuff

        -- Offset is the speed parameter between shifts
        local offset_up   = 0.55
        local offset_down = 0.5
        -- Mostly needed when offset is 0 (racing)
        local limiter = 5 /100

        -- Adjust offsets according to the performance target
        offset_up = interpolate(0,100, target, offset_up, 0)

        offset_down = offset_up +
                        -- Tames downshift at lower target
                        interpolate(0,100, target, _gear(-1, 0.1)/100, 0)

        -- Downshift lockout (prefers to stay in current gear than downshift)
        -- Without this, mashing on the throttle will drop a gear too short
        if (target > 98) and (speed > _gear(-1)*0.90) then offset_down = _gear(-1) end




	-- Launch Control
	local lc_ready = false
	local lc_start = false
	local data = ac.accessCarPhysics()

	if lc_start == true then
		ac.setEngineRPM(3500)
	end

	if car.speedKmh < 1 then
		if  data.brake > 0.85 and data.gas > 0 then
			--data.isShifterSupported = 1
			data.clutch = data.clutch + 1
			data.brake = 2
			data.handbrake = 2.5

			if car.rpm >= 3500 then
				ac.setEngineRPM(3500)
				ac.setMessage('Launch Control ready. Release gas pedal to start.')
				if car.speedKmh <= 40 and data.gas == 1 then
					lc_start = true	
					ac.setEngineRPM(3500)
				end
			end
		end
	end

	--[[if braking > 0.9 and car.speedKmh < 25 then
		data.clutch = 1
		data.isShifterSupported = 1
			if throttle > 0.95 and car.rpm > 2500 then
				ac.setEngineRPM(3500)
				data.gas = throttle * 0.5
				ac.setMessage('Launch Control ready')
				data.brake = braking
				data.handbrake = braking
			end
		end
					
		
	if car.speedKmh < 25 then
		ac.setMessage('Launch Control avaible. Push throttle and brake pedal to activate')
		if braking > 0.85 then
			data.handbrake = 10.5
			data.brake = 1
			if throttle > 0.9 then
				if car.rpm > 3500 then
					ac.setEngineRPM(3500)
					ac.setMessage('aghuj')
			end
		end
	
		if braking > 0.95 and throttle > 0.95 then
			ready = true
			ac.setMessage('Release brake to start')
			--car.rpm = 5000
			data.gas = throttle * 0.55
		end
	end]]


------------------------------------------------------------------------------------------------------------------

	-- misc and other stuff i dunno
		

		--[[local data = ac.accessCarPhysics()
			if data.requestedGearIndex == 1 then
				data.isShifterSupported = 1
			end
			
			if data.requestedGearIndex == 1 then
				data.gas = 0
			end]]--


end